<x-app-layout>

    <section class="page-header bg-tertiary" style="margin-top: 5rem">
        <div class="container">
            <div class="row">
                <div class="col-8 mx-auto text-center">
                    <h2 class="mb-3 text-capitalize">90+ Manually Tested Web Applications With Source Codes At Rs 65,000
                    </h2>
                    <p>For Software Developers, IT Companies & IT Startups</p>
                </div>
            </div>
        </div>
        <div class="has-shapes">
            <svg class="shape shape-left text-light" viewBox="0 0 192 752" fill="none"
                xmlns="http://www.w3.org/2000/svg">
                <path
                    d="M-30.883 0C-41.3436 36.4248 -22.7145 75.8085 4.29154 102.398C31.2976 128.987 65.8677 146.199 97.6457 166.87C129.424 187.542 160.139 213.902 172.162 249.847C193.542 313.799 149.886 378.897 129.069 443.036C97.5623 540.079 122.109 653.229 191 728.495"
                    stroke="currentColor" stroke-miterlimit="10" />
                <path
                    d="M-55.5959 7.52271C-66.0565 43.9475 -47.4274 83.3312 -20.4214 109.92C6.58466 136.51 41.1549 153.722 72.9328 174.393C104.711 195.064 135.426 221.425 147.449 257.37C168.829 321.322 125.174 386.42 104.356 450.559C72.8494 547.601 97.3965 660.752 166.287 736.018"
                    stroke="currentColor" stroke-miterlimit="10" />
                <path
                    d="M-80.3302 15.0449C-90.7909 51.4697 -72.1617 90.8535 -45.1557 117.443C-18.1497 144.032 16.4205 161.244 48.1984 181.915C79.9763 202.587 110.691 228.947 122.715 264.892C144.095 328.844 100.439 393.942 79.622 458.081C48.115 555.123 72.6622 668.274 141.552 743.54"
                    stroke="currentColor" stroke-miterlimit="10" />
                <path
                    d="M-105.045 22.5676C-115.506 58.9924 -96.8766 98.3762 -69.8706 124.965C-42.8646 151.555 -8.29436 168.767 23.4835 189.438C55.2615 210.109 85.9766 236.469 98.0001 272.415C119.38 336.367 75.7243 401.464 54.9072 465.604C23.4002 562.646 47.9473 675.796 116.838 751.063"
                    stroke="currentColor" stroke-miterlimit="10" />
            </svg>
            <svg class="shape shape-right text-light" viewBox="0 0 731 746" fill="none"
                xmlns="http://www.w3.org/2000/svg">
                <path
                    d="M12.1794 745.14C1.80036 707.275 -5.75764 666.015 8.73984 629.537C27.748 581.745 80.4729 554.968 131.538 548.843C182.604 542.703 234.032 552.841 285.323 556.748C336.615 560.64 391.543 557.276 433.828 527.964C492.452 487.323 511.701 408.123 564.607 360.255C608.718 320.353 675.307 307.183 731.29 327.323"
                    stroke="currentColor" stroke-miterlimit="10" />
                <path
                    d="M51.0253 745.14C41.2045 709.326 34.0538 670.284 47.7668 635.783C65.7491 590.571 115.623 565.242 163.928 559.449C212.248 553.641 260.884 563.235 309.4 566.931C357.916 570.627 409.887 567.429 449.879 539.701C505.35 501.247 523.543 426.331 573.598 381.059C615.326 343.314 678.324 330.853 731.275 349.906"
                    stroke="currentColor" stroke-miterlimit="10" />
                <path
                    d="M89.8715 745.14C80.6239 711.363 73.8654 674.568 86.8091 642.028C103.766 599.396 150.788 575.515 196.347 570.054C241.906 564.578 287.767 573.629 333.523 577.099C379.278 580.584 428.277 577.567 465.976 551.423C518.279 515.172 535.431 444.525 582.62 401.832C621.964 366.229 681.356 354.493 731.291 372.46"
                    stroke="currentColor" stroke-miterlimit="10" />
                <path
                    d="M128.718 745.14C120.029 713.414 113.678 678.838 125.837 648.274C141.768 608.221 185.939 585.788 228.737 580.659C271.536 575.515 314.621 584.008 357.6 587.282C400.58 590.556 446.607 587.719 482.028 563.16C531.163 529.111 547.275 462.733 591.612 422.635C628.572 389.19 684.375 378.162 731.276 395.043"
                    stroke="currentColor" stroke-miterlimit="10" />
                <path
                    d="M167.564 745.14C159.432 715.451 153.504 683.107 164.863 654.519C179.753 617.046 221.088 596.062 261.126 591.265C301.164 586.452 341.473 594.402 381.677 597.465C421.88 600.527 464.95 597.872 498.094 574.896C544.061 543.035 559.146 480.942 600.617 443.423C635.194 412.135 687.406 401.817 731.276 417.612"
                    stroke="currentColor" stroke-miterlimit="10" />
                <path
                    d="M817.266 289.466C813.108 259.989 787.151 237.697 759.261 227.271C731.372 216.846 701.077 215.553 671.666 210.904C642.254 206.24 611.795 197.156 591.664 175.224C555.853 136.189 566.345 75.5336 560.763 22.8649C552.302 -56.8256 498.487 -130.133 425 -162.081"
                    stroke="currentColor" stroke-miterlimit="10" />
                <path
                    d="M832.584 276.159C828.427 246.683 802.469 224.391 774.58 213.965C746.69 203.539 716.395 202.246 686.984 197.598C657.573 192.934 627.114 183.85 606.982 161.918C571.172 122.883 581.663 62.2275 576.082 9.55873C567.62 -70.1318 513.806 -143.439 440.318 -175.387"
                    stroke="currentColor" stroke-miterlimit="10" />
                <path
                    d="M847.904 262.853C843.747 233.376 817.789 211.084 789.9 200.659C762.011 190.233 731.716 188.94 702.304 184.292C672.893 179.627 642.434 170.544 622.303 148.612C586.492 109.577 596.983 48.9211 591.402 -3.74766C582.94 -83.4382 529.126 -156.746 455.638 -188.694"
                    stroke="currentColor" stroke-miterlimit="10" />
                <path
                    d="M863.24 249.547C859.083 220.07 833.125 197.778 805.236 187.353C777.347 176.927 747.051 175.634 717.64 170.986C688.229 166.321 657.77 157.237 637.639 135.306C601.828 96.2707 612.319 35.6149 606.738 -17.0538C598.276 -96.7443 544.462 -170.052 470.974 -202"
                    stroke="currentColor" stroke-miterlimit="10" />
            </svg>
        </div>
    </section>

    <div class="container py-5">
        <div class="row justify-content-center align-items-center">
            <div class="col-12">
                <div class="text-center">
                    <p class="mb-0" style="font-size: 30px; color: #111;">Some Live Demos Of Our Web Applications
                        Available Below</p>
                    <p class="mb-3" style="font-size: 25px; color: #f00;">View demos on Desktop for better view</p>
                </div>
            </div>
        </div>

        <div class="row justify-content-center">
            @foreach ($managementModules as $managementModule)

                <div class="icon-box-item col-lg-4 col-md-6">
                    <div class="block">
                        <div class="icon">
                            <i class="fas fa-truck"></i>
                        </div>
                        <h3 class="mb-3">{{ ucwords(preg_replace('/([a-z])([A-Z])/', '$1 $2', $managementModule)) }}</h3>
                        <p>
                            <span class="fa fa-star text-warning"></span>
                            <span class="fa fa-star text-warning"></span>
                            <span class="fa fa-star text-warning"></span>
                            <span class="fa fa-star text-warning"></span>
                            <span class="fa fa-star text-warning"></span>
                        </p>
                        <button type="button" class="btn btn-sm btn-outline-primary" data-bs-toggle="modal"
                            data-bs-target="#{{$managementModule}}">
                            Demo <i class="las la-arrow-right ms-1"></i>
                        </button>
                    </div>
                </div>

            @endforeach
        </div>


        {{-- <div class="row justify-content-center">

            <div class="icon-box-item col-lg-4 col-md-6">
                <div class="block">
                    <div class="icon">
                        <i class="fas fa-truck"></i>
                    </div>
                    <h3 class="mb-3">Apartment Management</h3>
                    <p>
                        <span class="fa fa-star text-warning"></span>
                        <span class="fa fa-star text-warning"></span>
                        <span class="fa fa-star text-warning"></span>
                        <span class="fa fa-star text-warning"></span>
                        <span class="fa fa-star text-warning"></span>
                    </p>
                    <button type="button" class="btn btn-sm btn-outline-primary" data-bs-toggle="modal"
                        data-bs-target="#apartmentManagement">
                        Demo <i class="las la-arrow-right ms-1"></i>
                    </button>
                </div>
            </div>

            <div class="icon-box-item col-lg-4 col-md-6">
                <div class="block">
                    <div class="icon">
                        <i class="fas fa-truck"></i>
                    </div>
                    <h3 class="mb-3">Apartment Management</h3>
                    <p>
                        <span class="fa fa-star text-warning"></span>
                        <span class="fa fa-star text-warning"></span>
                        <span class="fa fa-star text-warning"></span>
                        <span class="fa fa-star text-warning"></span>
                        <span class="fa fa-star text-warning"></span>
                    </p>
                    <button type="button" class="btn btn-sm btn-outline-primary" data-bs-toggle="modal"
                        data-bs-target="#blogManagement">
                        Demo <i class="las la-arrow-right ms-1"></i>
                    </button>
                </div>
            </div>

            <div class="icon-box-item col-lg-4 col-md-6">
                <div class="block">
                    <div class="icon">
                        <i class="fas fa-truck"></i>
                    </div>
                    <h3 class="mb-3">Apartment Management</h3>
                    <p>
                        <span class="fa fa-star text-warning"></span>
                        <span class="fa fa-star text-warning"></span>
                        <span class="fa fa-star text-warning"></span>
                        <span class="fa fa-star text-warning"></span>
                        <span class="fa fa-star text-warning"></span>
                    </p>
                    <button type="button" class="btn btn-sm btn-outline-primary" data-bs-toggle="modal"
                        data-bs-target="#carRepairManagement">
                        Demo <i class="las la-arrow-right ms-1"></i>
                    </button>
                </div>
            </div>

            <div class="icon-box-item col-lg-4 col-md-6">
                <div class="block">
                    <div class="icon">
                        <i class="fas fa-truck"></i>
                    </div>
                    <h3 class="mb-3">Apartment Management</h3>
                    <p>
                        <span class="fa fa-star text-warning"></span>
                        <span class="fa fa-star text-warning"></span>
                        <span class="fa fa-star text-warning"></span>
                        <span class="fa fa-star text-warning"></span>
                        <span class="fa fa-star text-warning"></span>
                    </p>
                    <button type="button" class="btn btn-sm btn-outline-primary" data-bs-toggle="modal"
                        data-bs-target="#cleaningManagement">
                        Demo <i class="las la-arrow-right ms-1"></i>
                    </button>
                </div>
            </div>

            <div class="icon-box-item col-lg-4 col-md-6">
                <div class="block">
                    <div class="icon">
                        <i class="fas fa-truck"></i>
                    </div>
                    <h3 class="mb-3">Apartment Management</h3>
                    <p>
                        <span class="fa fa-star text-warning"></span>
                        <span class="fa fa-star text-warning"></span>
                        <span class="fa fa-star text-warning"></span>
                        <span class="fa fa-star text-warning"></span>
                        <span class="fa fa-star text-warning"></span>
                    </p>
                    <button type="button" class="btn btn-sm btn-outline-primary" data-bs-toggle="modal"
                        data-bs-target="#cms1">
                        Demo <i class="las la-arrow-right ms-1"></i>
                    </button>
                </div>
            </div>

            <div class="icon-box-item col-lg-4 col-md-6">
                <div class="block">
                    <div class="icon">
                        <i class="fas fa-truck"></i>
                    </div>
                    <h3 class="mb-3">Apartment Management</h3>
                    <p>
                        <span class="fa fa-star text-warning"></span>
                        <span class="fa fa-star text-warning"></span>
                        <span class="fa fa-star text-warning"></span>
                        <span class="fa fa-star text-warning"></span>
                        <span class="fa fa-star text-warning"></span>
                    </p>
                    <button type="button" class="btn btn-sm btn-outline-primary" data-bs-toggle="modal"
                        data-bs-target="#cms2">
                        Demo <i class="las la-arrow-right ms-1"></i>
                    </button>
                </div>
            </div>

            <div class="icon-box-item col-lg-4 col-md-6">
                <div class="block">
                    <div class="icon">
                        <i class="fas fa-truck"></i>
                    </div>
                    <h3 class="mb-3">Apartment Management</h3>
                    <p>
                        <span class="fa fa-star text-warning"></span>
                        <span class="fa fa-star text-warning"></span>
                        <span class="fa fa-star text-warning"></span>
                        <span class="fa fa-star text-warning"></span>
                        <span class="fa fa-star text-warning"></span>
                    </p>
                    <button type="button" class="btn btn-sm btn-outline-primary" data-bs-toggle="modal"
                        data-bs-target="#cms4">
                        Demo <i class="las la-arrow-right ms-1"></i>
                    </button>
                </div>
            </div>

            <div class="icon-box-item col-lg-4 col-md-6">
                <div class="block">
                    <div class="icon">
                        <i class="fas fa-truck"></i>
                    </div>
                    <h3 class="mb-3">Apartment Management</h3>
                    <p>
                        <span class="fa fa-star text-warning"></span>
                        <span class="fa fa-star text-warning"></span>
                        <span class="fa fa-star text-warning"></span>
                        <span class="fa fa-star text-warning"></span>
                        <span class="fa fa-star text-warning"></span>
                    </p>
                    <button type="button" class="btn btn-sm btn-outline-primary" data-bs-toggle="modal"
                        data-bs-target="#constructionManagement">
                        Demo <i class="las la-arrow-right ms-1"></i>
                    </button>
                </div>
            </div>

            <div class="icon-box-item col-lg-4 col-md-6">
                <div class="block">
                    <div class="icon">
                        <i class="fas fa-truck"></i>
                    </div>
                    <h3 class="mb-3">Apartment Management</h3>
                    <p>
                        <span class="fa fa-star text-warning"></span>
                        <span class="fa fa-star text-warning"></span>
                        <span class="fa fa-star text-warning"></span>
                        <span class="fa fa-star text-warning"></span>
                        <span class="fa fa-star text-warning"></span>
                    </p>
                    <button type="button" class="btn btn-sm btn-outline-primary" data-bs-toggle="modal"
                        data-bs-target="#crmManagement">
                        Demo <i class="las la-arrow-right ms-1"></i>
                    </button>
                </div>
            </div>

            <div class="icon-box-item col-lg-4 col-md-6">
                <div class="block">
                    <div class="icon">
                        <i class="fas fa-truck"></i>
                    </div>
                    <h3 class="mb-3">Apartment Management</h3>
                    <p>
                        <span class="fa fa-star text-warning"></span>
                        <span class="fa fa-star text-warning"></span>
                        <span class="fa fa-star text-warning"></span>
                        <span class="fa fa-star text-warning"></span>
                        <span class="fa fa-star text-warning"></span>
                    </p>
                    <button type="button" class="btn btn-sm btn-outline-primary" data-bs-toggle="modal"
                        data-bs-target="#doctorManagement">
                        Demo <i class="las la-arrow-right ms-1"></i>
                    </button>
                </div>
            </div>

            <div class="icon-box-item col-lg-4 col-md-6">
                <div class="block">
                    <div class="icon">
                        <i class="fas fa-truck"></i>
                    </div>
                    <h3 class="mb-3">Apartment Management</h3>
                    <p>
                        <span class="fa fa-star text-warning"></span>
                        <span class="fa fa-star text-warning"></span>
                        <span class="fa fa-star text-warning"></span>
                        <span class="fa fa-star text-warning"></span>
                        <span class="fa fa-star text-warning"></span>
                    </p>
                    <button type="button" class="btn btn-sm btn-outline-primary" data-bs-toggle="modal"
                        data-bs-target="#eCommerceManagementVendor">
                        Demo <i class="las la-arrow-right ms-1"></i>
                    </button>
                </div>
            </div>

            <div class="icon-box-item col-lg-4 col-md-6">
                <div class="block">
                    <div class="icon">
                        <i class="fas fa-truck"></i>
                    </div>
                    <h3 class="mb-3">Apartment Management</h3>
                    <p>
                        <span class="fa fa-star text-warning"></span>
                        <span class="fa fa-star text-warning"></span>
                        <span class="fa fa-star text-warning"></span>
                        <span class="fa fa-star text-warning"></span>
                        <span class="fa fa-star text-warning"></span>
                    </p>
                    <button type="button" class="btn btn-sm btn-outline-primary" data-bs-toggle="modal"
                        data-bs-target="#eCommerceSingleVendor">
                        Demo <i class="las la-arrow-right ms-1"></i>
                    </button>
                </div>
            </div>

            <div class="icon-box-item col-lg-4 col-md-6">
                <div class="block">
                    <div class="icon">
                        <i class="fas fa-truck"></i>
                    </div>
                    <h3 class="mb-3">Apartment Management</h3>
                    <p>
                        <span class="fa fa-star text-warning"></span>
                        <span class="fa fa-star text-warning"></span>
                        <span class="fa fa-star text-warning"></span>
                        <span class="fa fa-star text-warning"></span>
                        <span class="fa fa-star text-warning"></span>
                    </p>
                    <button type="button" class="btn btn-sm btn-outline-primary" data-bs-toggle="modal"
                        data-bs-target="#emaarRealState">
                        Demo <i class="las la-arrow-right ms-1"></i>
                    </button>
                </div>
            </div>

            <div class="icon-box-item col-lg-4 col-md-6">
                <div class="block">
                    <div class="icon">
                        <i class="fas fa-truck"></i>
                    </div>
                    <h3 class="mb-3">Apartment Management</h3>
                    <p>
                        <span class="fa fa-star text-warning"></span>
                        <span class="fa fa-star text-warning"></span>
                        <span class="fa fa-star text-warning"></span>
                        <span class="fa fa-star text-warning"></span>
                        <span class="fa fa-star text-warning"></span>
                    </p>
                    <button type="button" class="btn btn-sm btn-outline-primary" data-bs-toggle="modal"
                        data-bs-target="#erpManagement">
                        Demo <i class="las la-arrow-right ms-1"></i>
                    </button>
                </div>
            </div>

            <div class="icon-box-item col-lg-4 col-md-6">
                <div class="block">
                    <div class="icon">
                        <i class="fas fa-truck"></i>
                    </div>
                    <h3 class="mb-3">Apartment Management</h3>
                    <p>
                        <span class="fa fa-star text-warning"></span>
                        <span class="fa fa-star text-warning"></span>
                        <span class="fa fa-star text-warning"></span>
                        <span class="fa fa-star text-warning"></span>
                        <span class="fa fa-star text-warning"></span>
                    </p>
                    <button type="button" class="btn btn-sm btn-outline-primary" data-bs-toggle="modal"
                        data-bs-target="#fileSharing">
                        Demo <i class="las la-arrow-right ms-1"></i>
                    </button>
                </div>
            </div>

            <div class="icon-box-item col-lg-4 col-md-6">
                <div class="block">
                    <div class="icon">
                        <i class="fas fa-truck"></i>
                    </div>
                    <h3 class="mb-3">Apartment Management</h3>
                    <p>
                        <span class="fa fa-star text-warning"></span>
                        <span class="fa fa-star text-warning"></span>
                        <span class="fa fa-star text-warning"></span>
                        <span class="fa fa-star text-warning"></span>
                        <span class="fa fa-star text-warning"></span>
                    </p>
                    <button type="button" class="btn btn-sm btn-outline-primary" data-bs-toggle="modal"
                        data-bs-target="#hrmsHumanResourceManagement">
                        Demo <i class="las la-arrow-right ms-1"></i>
                    </button>
                </div>
            </div>

            <div class="icon-box-item col-lg-4 col-md-6">
                <div class="block">
                    <div class="icon">
                        <i class="fas fa-truck"></i>
                    </div>
                    <h3 class="mb-3">Apartment Management</h3>
                    <p>
                        <span class="fa fa-star text-warning"></span>
                        <span class="fa fa-star text-warning"></span>
                        <span class="fa fa-star text-warning"></span>
                        <span class="fa fa-star text-warning"></span>
                        <span class="fa fa-star text-warning"></span>
                    </p>
                    <button type="button" class="btn btn-sm btn-outline-primary" data-bs-toggle="modal"
                        data-bs-target="#instituteManagement">
                        Demo <i class="las la-arrow-right ms-1"></i>
                    </button>
                </div>
            </div>

            <div class="icon-box-item col-lg-4 col-md-6">
                <div class="block">
                    <div class="icon">
                        <i class="fas fa-truck"></i>
                    </div>
                    <h3 class="mb-3">Apartment Management</h3>
                    <p>
                        <span class="fa fa-star text-warning"></span>
                        <span class="fa fa-star text-warning"></span>
                        <span class="fa fa-star text-warning"></span>
                        <span class="fa fa-star text-warning"></span>
                        <span class="fa fa-star text-warning"></span>
                    </p>
                    <button type="button" class="btn btn-sm btn-outline-primary" data-bs-toggle="modal"
                        data-bs-target="#inventoryManagement">
                        Demo <i class="las la-arrow-right ms-1"></i>
                    </button>
                </div>
            </div>

            <div class="icon-box-item col-lg-4 col-md-6">
                <div class="block">
                    <div class="icon">
                        <i class="fas fa-truck"></i>
                    </div>
                    <h3 class="mb-3">Apartment Management</h3>
                    <p>
                        <span class="fa fa-star text-warning"></span>
                        <span class="fa fa-star text-warning"></span>
                        <span class="fa fa-star text-warning"></span>
                        <span class="fa fa-star text-warning"></span>
                        <span class="fa fa-star text-warning"></span>
                    </p>
                    <button type="button" class="btn btn-sm btn-outline-primary" data-bs-toggle="modal"
                        data-bs-target="#jobPortalManagement">
                        Demo <i class="las la-arrow-right ms-1"></i>
                    </button>
                </div>
            </div>

            <div class="icon-box-item col-lg-4 col-md-6">
                <div class="block">
                    <div class="icon">
                        <i class="fas fa-truck"></i>
                    </div>
                    <h3 class="mb-3">Apartment Management</h3>
                    <p>
                        <span class="fa fa-star text-warning"></span>
                        <span class="fa fa-star text-warning"></span>
                        <span class="fa fa-star text-warning"></span>
                        <span class="fa fa-star text-warning"></span>
                        <span class="fa fa-star text-warning"></span>
                    </p>
                    <button type="button" class="btn btn-sm btn-outline-primary" data-bs-toggle="modal"
                        data-bs-target="#loanManagement">
                        Demo <i class="las la-arrow-right ms-1"></i>
                    </button>
                </div>
            </div>

            <div class="icon-box-item col-lg-4 col-md-6">
                <div class="block">
                    <div class="icon">
                        <i class="fas fa-truck"></i>
                    </div>
                    <h3 class="mb-3">Apartment Management</h3>
                    <p>
                        <span class="fa fa-star text-warning"></span>
                        <span class="fa fa-star text-warning"></span>
                        <span class="fa fa-star text-warning"></span>
                        <span class="fa fa-star text-warning"></span>
                        <span class="fa fa-star text-warning"></span>
                    </p>
                    <button type="button" class="btn btn-sm btn-outline-primary" data-bs-toggle="modal"
                        data-bs-target="#marketplaceEcommerce">
                        Demo <i class="las la-arrow-right ms-1"></i>
                    </button>
                </div>
            </div>

            <div class="icon-box-item col-lg-4 col-md-6">
                <div class="block">
                    <div class="icon">
                        <i class="fas fa-truck"></i>
                    </div>
                    <h3 class="mb-3">Apartment Management</h3>
                    <p>
                        <span class="fa fa-star text-warning"></span>
                        <span class="fa fa-star text-warning"></span>
                        <span class="fa fa-star text-warning"></span>
                        <span class="fa fa-star text-warning"></span>
                        <span class="fa fa-star text-warning"></span>
                    </p>
                    <button type="button" class="btn btn-sm btn-outline-primary" data-bs-toggle="modal"
                        data-bs-target="#matrimony">
                        Demo <i class="las la-arrow-right ms-1"></i>
                    </button>
                </div>
            </div>

            <div class="icon-box-item col-lg-4 col-md-6">
                <div class="block">
                    <div class="icon">
                        <i class="fas fa-truck"></i>
                    </div>
                    <h3 class="mb-3">Apartment Management</h3>
                    <p>
                        <span class="fa fa-star text-warning"></span>
                        <span class="fa fa-star text-warning"></span>
                        <span class="fa fa-star text-warning"></span>
                        <span class="fa fa-star text-warning"></span>
                        <span class="fa fa-star text-warning"></span>
                    </p>
                    <button type="button" class="btn btn-sm btn-outline-primary" data-bs-toggle="modal"
                        data-bs-target="#multiWebsiteManagement">
                        Demo <i class="las la-arrow-right ms-1"></i>
                    </button>
                </div>
            </div>

            <div class="icon-box-item col-lg-4 col-md-6">
                <div class="block">
                    <div class="icon">
                        <i class="fas fa-truck"></i>
                    </div>
                    <h3 class="mb-3">Apartment Management</h3>
                    <p>
                        <span class="fa fa-star text-warning"></span>
                        <span class="fa fa-star text-warning"></span>
                        <span class="fa fa-star text-warning"></span>
                        <span class="fa fa-star text-warning"></span>
                        <span class="fa fa-star text-warning"></span>
                    </p>
                    <button type="button" class="btn btn-sm btn-outline-primary" data-bs-toggle="modal"
                        data-bs-target="#newsApp">
                        Demo <i class="las la-arrow-right ms-1"></i>
                    </button>
                </div>
            </div>

            <div class="icon-box-item col-lg-4 col-md-6">
                <div class="block">
                    <div class="icon">
                        <i class="fas fa-truck"></i>
                    </div>
                    <h3 class="mb-3">Apartment Management</h3>
                    <p>
                        <span class="fa fa-star text-warning"></span>
                        <span class="fa fa-star text-warning"></span>
                        <span class="fa fa-star text-warning"></span>
                        <span class="fa fa-star text-warning"></span>
                        <span class="fa fa-star text-warning"></span>
                    </p>
                    <button type="button" class="btn btn-sm btn-outline-primary" data-bs-toggle="modal"
                        data-bs-target="#pharmacyApp">
                        Demo <i class="las la-arrow-right ms-1"></i>
                    </button>
                </div>
            </div>

            <div class="icon-box-item col-lg-4 col-md-6">
                <div class="block">
                    <div class="icon">
                        <i class="fas fa-truck"></i>
                    </div>
                    <h3 class="mb-3">Apartment Management</h3>
                    <p>
                        <span class="fa fa-star text-warning"></span>
                        <span class="fa fa-star text-warning"></span>
                        <span class="fa fa-star text-warning"></span>
                        <span class="fa fa-star text-warning"></span>
                        <span class="fa fa-star text-warning"></span>
                    </p>
                    <button type="button" class="btn btn-sm btn-outline-primary" data-bs-toggle="modal"
                        data-bs-target="#restaurant">
                        Demo <i class="las la-arrow-right ms-1"></i>
                    </button>
                </div>
            </div>

            <div class="icon-box-item col-lg-4 col-md-6">
                <div class="block">
                    <div class="icon">
                        <i class="fas fa-truck"></i>
                    </div>
                    <h3 class="mb-3">Apartment Management</h3>
                    <p>
                        <span class="fa fa-star text-warning"></span>
                        <span class="fa fa-star text-warning"></span>
                        <span class="fa fa-star text-warning"></span>
                        <span class="fa fa-star text-warning"></span>
                        <span class="fa fa-star text-warning"></span>
                    </p>
                    <button type="button" class="btn btn-sm btn-outline-primary" data-bs-toggle="modal"
                        data-bs-target="#resumeManagement">
                        Demo <i class="las la-arrow-right ms-1"></i>
                    </button>
                </div>
            </div>

            <div class="icon-box-item col-lg-4 col-md-6">
                <div class="block">
                    <div class="icon">
                        <i class="fas fa-truck"></i>
                    </div>
                    <h3 class="mb-3">Apartment Management</h3>
                    <p>
                        <span class="fa fa-star text-warning"></span>
                        <span class="fa fa-star text-warning"></span>
                        <span class="fa fa-star text-warning"></span>
                        <span class="fa fa-star text-warning"></span>
                        <span class="fa fa-star text-warning"></span>
                    </p>
                    <button type="button" class="btn btn-sm btn-outline-primary" data-bs-toggle="modal"
                        data-bs-target="#saloonManagement">
                        Demo <i class="las la-arrow-right ms-1"></i>
                    </button>
                </div>
            </div>

            <div class="icon-box-item col-lg-4 col-md-6">
                <div class="block">
                    <div class="icon">
                        <i class="fas fa-truck"></i>
                    </div>
                    <h3 class="mb-3">Apartment Management</h3>
                    <p>
                        <span class="fa fa-star text-warning"></span>
                        <span class="fa fa-star text-warning"></span>
                        <span class="fa fa-star text-warning"></span>
                        <span class="fa fa-star text-warning"></span>
                        <span class="fa fa-star text-warning"></span>
                    </p>
                    <button type="button" class="btn btn-sm btn-outline-primary" data-bs-toggle="modal"
                        data-bs-target="#schoolOneSchoolManagement">
                        Demo <i class="las la-arrow-right ms-1"></i>
                    </button>
                </div>
            </div>

            <div class="icon-box-item col-lg-4 col-md-6">
                <div class="block">
                    <div class="icon">
                        <i class="fas fa-truck"></i>
                    </div>
                    <h3 class="mb-3">Apartment Management</h3>
                    <p>
                        <span class="fa fa-star text-warning"></span>
                        <span class="fa fa-star text-warning"></span>
                        <span class="fa fa-star text-warning"></span>
                        <span class="fa fa-star text-warning"></span>
                        <span class="fa fa-star text-warning"></span>
                    </p>
                    <button type="button" class="btn btn-sm btn-outline-primary" data-bs-toggle="modal"
                        data-bs-target="#travelAgency">
                        Demo <i class="las la-arrow-right ms-1"></i>
                    </button>
                </div>
            </div>
        </div> --}}

    </div>


    <!-- ################## apartmentManagement #######################-->
    <div class="modal apartmentManagement fade" id="apartmentManagement" tabindex="-1"
        aria-labelledby="apartmentManagementLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header border-bottom-0">
                    <h4 class="modal-title" id="exampleModalLabel">Demo Detail</h4>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">

                    <p>
                        <strong>URL:</strong>
                        <a href="https://apartment.softwaredemopreview.online/dashboard.php" target="_blank">Visit</a>
                    </p>
                    <ul>
                        <li>
                            <strong>Super Admin:</strong>
                            superadmin@superadmin.com / 123456
                        </li>
                        <li>
                            <strong>Admin:</strong> tony@yahoo.com /
                            123456
                        </li>
                        <li>
                            <strong>Owner:</strong> john@gmail.com /
                            123456
                        </li>
                        <li>
                            <strong>Employee:</strong>
                            johnsina@gmail.com / 123456
                        </li>
                        <li>
                            <strong>Tenant:</strong> jimcary@yahoo.com /
                            123456
                        </li>
                    </ul>



                </div>
            </div>
        </div>
    </div>
    <!-- ################## blogManagement #######################-->
    <div class="modal blogManagement fade" id="blogManagement" tabindex="-1" aria-labelledby="blogManagementLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header border-bottom-0">
                    <h4 class="modal-title" id="exampleModalLabel">Demo Detail</h4>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <p>
                        <strong>URL:</strong>
                        <a href="https://blog.softwaredemopreview.online/" target="_blank">Visit</a>
                    </p>
                    <p>
                        <strong>Login URL:</strong>
                        <a href="https://blog.softwaredemopreview.online/admin/login" target="_blank">Admin Login</a>
                    </p>
                    <p>
                        <strong>Admin:</strong> admin@email.com / 123456
                    </p>
                </div>
            </div>
        </div>
    </div>
    <!-- ################## carRepairManagement #######################-->
    <div class="modal carRepairManagement fade" id="carRepairManagement" tabindex="-1"
        aria-labelledby="carRepairManagementLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header border-bottom-0">
                    <h4 class="modal-title" id="exampleModalLabel">Demo Detail</h4>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <p>
                        <strong>URL:</strong>
                        <a href="https://carrepair.softwaredemopreview.online" target="_blank">Visit</a>
                    </p>
                    <p>
                        <strong>Login URL:</strong>
                        <a href="https://carrepair.softwaredemopreview.online/admin" target="_blank">Admin Login</a>
                    </p>
                    <p><strong>Admin:</strong> caradmin / 123456</p>
                </div>
            </div>
        </div>
    </div>
    <!-- ################## cleaningManagement #######################-->
    <div class="modal cleaningManagement fade" id="cleaningManagement" tabindex="-1"
        aria-labelledby="cleaningManagementLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header border-bottom-0">
                    <h4 class="modal-title" id="exampleModalLabel">Demo Detail</h4>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <p>
                        <strong>URL:</strong>
                        <a href="https://cleaning.softwaredemopreview.online" target="_blank">Visit</a>
                    </p>
                    <p>
                        <strong>Login URL:</strong>
                        <a href="https://cleaning.softwaredemopreview.online/login/admin" target="_blank">Admin
                            Login</a>
                    </p>
                    <p>
                        <strong>Admin:</strong> admin@email.com / 123456
                    </p>
                </div>
            </div>
        </div>
    </div>
    <!-- ################## cms1 #######################-->
    <div class="modal cms1 fade" id="cms1" tabindex="-1" aria-labelledby="cms1Label" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header border-bottom-0">
                    <h4 class="modal-title" id="exampleModalLabel">Demo Detail</h4>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <p>
                        <strong>URL:</strong>
                        <a href="https://cms1.softwaredemopreview.online" target="_blank">Visit</a>
                    </p>
                    <p>
                        <strong>Login URL:</strong>
                        <a href="https://cms1.softwaredemopreview.online/admin" target="_blank">Admin Login</a>
                    </p>
                    <p>
                        <strong>Admin:</strong> admin@email.com / 123456
                    </p>
                </div>
            </div>
        </div>
    </div>
    <!-- ################## cms2 #######################-->
    <div class="modal cms2 fade" id="cms2" tabindex="-1" aria-labelledby="cms2Label" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header border-bottom-0">
                    <h4 class="modal-title" id="exampleModalLabel">Demo Detail</h4>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <p>
                        <strong>URL:</strong>
                        <a href="http://cms2.demopreview.in/" target="_blank">Visit</a>
                    </p>
                    <p>
                        <strong>Login URL:</strong>
                        <a href="http://cms2.demopreview.in/admin" target="_blank">Admin Login</a>
                    </p>
                    <p>
                        <strong>Admin:</strong> admin@email.com / 123456
                    </p>
                </div>
            </div>
        </div>
    </div>
    <!-- ################## cms4 #######################-->
    <div class="modal cms4 fade" id="cms4" tabindex="-1" aria-labelledby="cms4Label" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header border-bottom-0">
                    <h4 class="modal-title" id="exampleModalLabel">Demo Detail</h4>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <p>
                        <strong>URL:</strong>
                        <a href="https://construction.softwaredemopreview.online/" target="_blank">Visit</a>
                    </p>
                    <p>
                        <strong>Login URL:</strong>
                        <a href="https://construction.softwaredemopreview.online/admin/" target="_blank">Admin Login</a>
                    </p>
                    <p>
                        <strong>Admin:</strong> admin@email.com / 123456
                    </p>
                </div>
            </div>
        </div>
    </div>
    <!-- ################## constructionManagement #######################-->
    <div class="modal constructionManagement fade" id="constructionManagement" tabindex="-1"
        aria-labelledby="constructionManagementLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header border-bottom-0">
                    <h4 class="modal-title" id="exampleModalLabel">Demo Detail</h4>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <p>
                        <strong>URL:</strong>
                        <a href="https://construction.softwaredemopreview.online/" target="_blank">Visit</a>
                    </p>
                    <p>
                        <strong>Login URL:</strong>
                        <a href="https://construction.softwaredemopreview.online/admin/" target="_blank">Admin Login</a>
                    </p>
                    <p>
                        <strong>Admin:</strong> admin@email.com / 123456
                    </p>
                </div>
            </div>
        </div>
    </div>
    <!-- ################## crmManagement #######################-->
    <div class="modal crmManagement fade" id="crmManagement" tabindex="-1" aria-labelledby="crmManagementLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header border-bottom-0">
                    <h4 class="modal-title" id="exampleModalLabel">Demo Detail</h4>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <p>
                        <strong>URL:</strong>
                        <a href="https://crm.softwaredemopreview.online/?ng=login/" target="_blank">Visit</a>
                    </p>
                    <p>
                        <strong>Admin:</strong> admin@email.com / 12345
                    </p>
                </div>
            </div>
        </div>
    </div>
    <!-- ################## doctorManagement #######################-->
    <div class="modal doctorManagement fade" id="doctorManagement" tabindex="-1" aria-labelledby="doctorManagementLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header border-bottom-0">
                    <h4 class="modal-title" id="exampleModalLabel">Demo Detail</h4>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <p>
                        <strong>URL:</strong>
                        <a href="https://doctor.softwaredemopreview.online" target="_blank">Visit</a>
                    </p>
                    <p>
                        <strong>Admin Login URL:</strong>
                        <a href="https://doctor.softwaredemopreview.online/auth/login" target="_blank">Admin Login</a>
                    </p>
                    <p>
                        <strong>Admin:</strong> admin@email.com / 123456
                    </p>
                </div>
            </div>
        </div>
    </div>
    <!-- ################## eCommerceManagementVendor #######################-->
    <div class="modal eCommerceManagementVendor fade" id="eCommerceManagementVendor" tabindex="-1"
        aria-labelledby="eCommerceManagementVendorLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header border-bottom-0">
                    <h4 class="modal-title" id="exampleModalLabel">Demo Detail</h4>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <p>
                        <strong>URL:</strong>
                        <a href="https://ecommercemultivendor.softwaredemopreview.online/" target="_blank">Visit</a>
                    </p>
                    <p>
                        <strong>Admin Login URL:</strong>
                        <a href="https://ecommercemultivendor.softwaredemopreview.online/" target="_blank">Admin
                            Login</a>
                    </p>
                    <ul>
                        <li>
                            <strong>Admin:</strong> admin@email.com /
                            123456
                        </li>
                        <li>
                            <strong>Seller:</strong> seller@email.com /
                            123456
                        </li>
                        <li>
                            <strong>Customer:</strong>
                            customer@email.com / 123456
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
    <!-- ################## eCommerceSingleVendor #######################-->
    <div class="modal eCommerceSingleVendor fade" id="eCommerceSingleVendor" tabindex="-1"
        aria-labelledby="eCommerceSingleVendorLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header border-bottom-0">
                    <h4 class="modal-title" id="exampleModalLabel">Demo Detail</h4>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <p>
                        <strong>URL:</strong>
                        <a href="https://ecomsingle.softwaredemopreview.online/" target="_blank">Visit</a>
                    </p>
                    <p>
                        <strong>Admin Login URL:</strong>
                        <a href="https://ecomsingle.softwaredemopreview.online/admin/login" target="_blank">Admin
                            Login</a>
                    </p>
                    <ul>
                        <li>
                            <strong>Admin:</strong> admin@email.com /
                            123456
                        </li>
                        <li>
                            <strong>Vendor:</strong> vendor@email.com /
                            123456
                        </li>
                        <li>
                            <strong>User:</strong> user@email.com /
                            123456
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
    <!-- ################## emaarRealState #######################-->
    <div class="modal emaarRealState fade" id="emaarRealState" tabindex="-1" aria-labelledby="emaarRealStateLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header border-bottom-0">
                    <h4 class="modal-title" id="exampleModalLabel">Demo Detail</h4>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <p>
                        <strong>URL:</strong>
                        <a href="https://emaar.demopreview.in/" target="_blank">Visit</a>
                    </p>
                    <p>
                        <strong>Login URL:</strong>
                        <a href="https://emaar.demopreview.in/admin/login" target="_blank">Admin Login</a>
                    </p>
                    <p>
                        <strong>Admin:</strong> admin@email.com / 123456
                    </p>
                </div>
            </div>
        </div>
    </div>
    <!-- ################## erpManagement #######################-->
    <div class="modal erpManagement fade" id="erpManagement" tabindex="-1" aria-labelledby="erpManagementLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header border-bottom-0">
                    <h4 class="modal-title" id="exampleModalLabel">Demo Detail</h4>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <p>
                        <strong>URL:</strong>
                        <a href="https://erp.softwaredemopreview.online/login" target="_blank">Visit</a>
                    </p>
                    <p>
                        <strong>Admin:</strong> admin@email.com / 123456
                    </p>
                </div>
            </div>
        </div>
    </div>
    <!-- ################## fileSharing #######################-->
    <div class="modal fileSharing fade" id="fileSharing" tabindex="-1" aria-labelledby="fileSharingLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header border-bottom-0">
                    <h4 class="modal-title" id="exampleModalLabel">Demo Detail</h4>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <p>
                        <strong>URL:</strong>
                        <a href="https://filesharing.demopreview.in/" target="_blank">Visit</a>
                    </p>
                </div>
            </div>
        </div>
    </div>
    <!-- ################## hrmsHumanResourceManagement #######################-->
    <div class="modal hrmsHumanResourceManagement fade" id="hrmsHumanResourceManagement" tabindex="-1"
        aria-labelledby="hrmsHumanResourceManagementLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header border-bottom-0">
                    <h4 class="modal-title" id="exampleModalLabel">Demo Detail</h4>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <p>
                        <strong>URL:</strong>
                        <a href="http://hrms.demopreview.in" target="_blank">Visit</a>
                    </p>
                    <p>
                        <strong>Admin:</strong> admin@email.com / 123456
                    </p>
                </div>
            </div>
        </div>
    </div>
    <!-- ################## instituteManagement #######################-->
    <div class="modal instituteManagement fade" id="instituteManagement" tabindex="-1"
        aria-labelledby="instituteManagementLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header border-bottom-0">
                    <h4 class="modal-title" id="exampleModalLabel">Demo Detail</h4>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <p>
                        <strong>URL:</strong>
                        <a href="http://institute1.demopreview.in/dashboard" target="_blank">Visit</a>
                    </p>
                    <p>
                        <strong>Login URL:</strong>
                        <a href="http://institute1.demopreview.in/dashboard/auth" target="_blank">Login</a>
                    </p>
                    <p>
                        <strong>Admin:</strong> admin@gmail.com / 123456
                    </p>
                </div>
            </div>
        </div>
    </div>
    <!-- ################## inventoryManagement #######################-->
    <div class="modal inventoryManagement fade" id="inventoryManagement" tabindex="-1"
        aria-labelledby="inventoryManagementLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header border-bottom-0">
                    <h4 class="modal-title" id="exampleModalLabel">Demo Detail</h4>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <p>
                        <strong>Login URL:</strong>
                        <a href="https://inventory.softwaredemopreview.online/" target="_blank">Admin Login</a>
                    </p>
                    <p>
                        <strong>Admin:</strong> admin@email.com / 123456
                    </p>
                </div>
            </div>
        </div>
    </div>
    <!-- ################## jobPortalManagement #######################-->
    <div class="modal jobPortalManagement fade" id="jobPortalManagement" tabindex="-1"
        aria-labelledby="jobPortalManagementLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header border-bottom-0">
                    <h4 class="modal-title" id="exampleModalLabel">Demo Detail</h4>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <p>
                        <strong>URL:</strong>
                        <a href="https://jobportal.demopreview.in" target="_blank">Visit</a>
                    </p>
                    <p>
                        <strong>Login URL:</strong>
                        <a href="https://jobportal.demopreview.in/admin" target="_blank">Admin Login</a>
                    </p>
                    <p>
                        <strong>Admin:</strong> admin@email.com / 123456
                    </p>
                </div>
            </div>
        </div>
    </div>
    <!-- ################## loanManagement #######################-->
    <div class="modal loanManagement fade" id="loanManagement" tabindex="-1" aria-labelledby="loanManagementLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header border-bottom-0">
                    <h4 class="modal-title" id="exampleModalLabel">Demo Detail</h4>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <p>
                        <strong>Login URL:</strong>
                        <a href="http://loan.demopreview.in/index.php" target="_blank">Admin Login</a>
                    </p>
                    <p><strong>Admin:</strong> admin / admin</p>
                </div>
            </div>
        </div>
    </div>
    <!-- ################## marketplaceEcommerce #######################-->
    <div class="modal marketplaceEcommerce fade" id="marketplaceEcommerce" tabindex="-1"
        aria-labelledby="marketplaceEcommerceLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header border-bottom-0">
                    <h4 class="modal-title" id="exampleModalLabel">Demo Detail</h4>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <p>
                        <strong>URL:</strong>
                        <a href="http://marketplace.demopreview.in/" target="_blank">Visit</a>
                    </p>
                    <p>
                        <strong>Login URL:</strong>
                        <a href="http://marketplace.demopreview.in/login" target="_blank">Login</a>
                    </p>
                    <p>
                        <strong>Super Admin:</strong>
                        superadmin@demo.com / 123456
                    </p>
                    <p>
                        <strong>Admin:</strong> admin@demo.com / 123456
                    </p>
                    <p>
                        <strong>Merchant:</strong> merchant@demo.com /
                        123456
                    </p>
                </div>
            </div>
        </div>
    </div>
    <!-- ################## matrimony #######################-->
    <div class="modal matrimony fade" id="matrimony" tabindex="-1" aria-labelledby="matrimonyLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header border-bottom-0">
                    <h4 class="modal-title" id="exampleModalLabel">Demo Detail</h4>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <p>
                        <strong>URL:</strong>
                        <a href="https://matrimony.softwaredemopreview.online/" target="_blank">Visit</a>
                    </p>
                    <p>
                        <strong>Login URL:</strong>
                        <a href="https://matrimony.softwaredemopreview.online/admin" target="_blank">Admin Login</a>
                    </p>
                    <p>
                        <strong>Admin:</strong> admin@email.com / 123456
                    </p>
                </div>
            </div>
        </div>
    </div>
    <!-- ################## multiWebsiteManagement #######################-->
    <div class="modal multiWebsiteManagement fade" id="multiWebsiteManagement" tabindex="-1"
        aria-labelledby="multiWebsiteManagementLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header border-bottom-0">
                    <h4 class="modal-title" id="exampleModalLabel">Demo Detail</h4>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <p>
                        <strong>URL:</strong>
                        <a href="http://multiwebsite.demopreview.in" target="_blank">Visit</a>
                    </p>
                    <p>
                        <strong>Login URL:</strong>
                        <a href="http://multiwebsite.demopreview.in/login" target="_blank">Admin Login</a>
                    </p>
                    <p>
                        <strong>Admin:</strong> admin@email.com / 123456
                    </p>
                </div>
            </div>
        </div>
    </div>
    <!-- ################## newsApp #######################-->
    <div class="modal newsApp fade" id="newsApp" tabindex="-1" aria-labelledby="newsAppLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header border-bottom-0">
                    <h4 class="modal-title" id="exampleModalLabel">Demo Detail</h4>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <p>
                        <strong>URL:</strong>
                        <a href="https://news.softwaredemopreview.online/" target="_blank">Visit</a>
                    </p>
                    <p>
                        <strong>Admin:</strong> admin@email.com / 123456
                    </p>
                </div>
            </div>
        </div>
    </div>
    <!-- ################## pharmacyApp #######################-->
    <div class="modal pharmacyApp fade" id="pharmacyApp" tabindex="-1" aria-labelledby="pharmacyAppLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header border-bottom-0">
                    <h4 class="modal-title" id="exampleModalLabel">Demo Detail</h4>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <p>
                        <strong>Login URL:</strong>
                        <a href="http://pharmacy.demopreview.in/index.php?route=login" target="_blank">Admin Login</a>
                    </p>
                    <p><strong>Admin:</strong> admin / 123456</p>
                </div>
            </div>
        </div>
    </div>
    <!-- ################## restaurant #######################-->
    <div class="modal restaurant fade" id="restaurant" tabindex="-1" aria-labelledby="restaurantLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header border-bottom-0">
                    <h4 class="modal-title" id="exampleModalLabel">Demo Detail</h4>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <p>
                        <strong>URL:</strong>
                        <a href="https://restaurant.demopreview.in" target="_blank">Visit</a>
                    </p>
                    <p>
                        <strong>Login URL:</strong>
                        <a href="https://restaurant.demopreview.in/login" target="_blank">Admin Login</a>
                    </p>
                    <p>
                        <strong>Admin:</strong> admin@email.com / 123456
                    </p>
                    <p>
                        <strong>Additional Admin:</strong>
                        retaestudio@gmail.com / 123456
                    </p>
                </div>
            </div>
        </div>
    </div>
    <!-- ################## resumeManagement #######################-->
    <div class="modal resumeManagement fade" id="resumeManagement" tabindex="-1" aria-labelledby="resumeManagementLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header border-bottom-0">
                    <h4 class="modal-title" id="exampleModalLabel">Demo Detail</h4>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <p>
                        <strong>URL:</strong>
                        <a href="http://resume.demopreview.in" target="_blank">Visit</a>
                    </p>
                    <p>
                        <strong>Login URL:</strong>
                        <a href="http://resume.demopreview.in/login" target="_blank">Admin Login</a>
                    </p>
                    <p>
                        <strong>Admin:</strong> admin@email.com / 123456
                    </p>
                </div>
            </div>
        </div>
    </div>
    <!-- ################## saloonManagement #######################-->
    <div class="modal saloonManagement fade" id="saloonManagement" tabindex="-1" aria-labelledby="saloonManagementLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header border-bottom-0">
                    <h4 class="modal-title" id="exampleModalLabel">Demo Detail</h4>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <p>
                        <strong>URL:</strong>
                        <a href="http://saloon.demopreview.in" target="_blank">Visit</a>
                    </p>
                    <p>
                        <strong>Login URL:</strong>
                        <a href="http://saloon.demopreview.in/login" target="_blank">Admin Login</a>
                    </p>
                    <p>
                        <strong>Admin:</strong> admin@email.com / 123456
                    </p>
                </div>
            </div>
        </div>
    </div>
    <!-- ################## schoolOneSchoolManagement #######################-->
    <div class="modal schoolOneSchoolManagement fade" id="schoolOneSchoolManagement" tabindex="-1"
        aria-labelledby="schoolOneSchoolManagementLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header border-bottom-0">
                    <h4 class="modal-title" id="exampleModalLabel">Demo Detail</h4>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <p>
                        <strong>URL:</strong>
                        <a href="https://schoolone.softwaredemopreview.online" target="_blank">Visit</a>
                    </p>
                    <p>
                        <strong>Login URL:</strong>
                        <a href="https://schoolone.softwaredemopreview.online/login" target="_blank">Admin Login</a>
                    </p>
                    <p>
                        <strong>Admin:</strong> admin@email.com / 123456
                    </p>
                </div>
            </div>
        </div>
    </div>
    <!-- ################## travelAgency #######################-->
    <div class="modal travelAgency fade" id="travelAgency" tabindex="-1" aria-labelledby="travelAgencyLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header border-bottom-0">
                    <h4 class="modal-title" id="exampleModalLabel">Demo Detail</h4>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <p>
                        <strong>Login URL:</strong>
                        <a href="https://travel.demopreview.in/login?redirect=%2Fadmin" target="_blank">Admin Login</a>
                    </p>
                    <p>
                        <strong>Admin:</strong> admin@email.com / 123456
                    </p>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>