<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

class FrontendController extends Controller
{
    public function index()
    {
        return view('pages.home', ['pageTitle' => '', 'description' => '']);
    }
    public function exploreProducts()
    {
        $managementModules = [
            'apartmentManagement',
            'blogManagement',
            'carRepairManagement',
            'cleaningManagement',
            'cms1',
            'cms2',
            'cms4',
            'constructionManagement',
            'crmManagement',
            'doctorManagement',
            'eCommerceManagementVendor',
            'eCommerceSingleVendor',
            'emaarRealState',
            'erpManagement',
            'fileSharing',
            'hrmsHumanResourceManagement',
            'instituteManagement',
            'inventoryManagement',
            'jobPortalManagement',
            'loanManagement',
            'marketplaceEcommerce',
            'matrimony',
            'multiWebsiteManagement',
            'newsApp',
            'pharmacyApp',
            'restaurant',
            'resumeManagement',
            'saloonManagement',
            'schoolOneSchoolManagement',
            'travelAgency',
        ];
        
        return view('pages.explore-product', ['pageTitle' => '', 'description' => '','managementModules' => $managementModules]);
    }
    public function aboutBundle()
    {
        return view('pages.about-bundle', ['pageTitle' => '', 'description' => '']);
    }
    public function about()
    {
        return view('pages.about', ['pageTitle' => '', 'description' => '']);
    }
    public function howToBuy()
    {
        return view('pages.how-to-buy', ['pageTitle' => '', 'description' => '']);
    }
    public function termsAndCondition()
    {
        return view('pages.terms-and-condition', ['pageTitle' => '', 'description' => '']);
    }
    public function privacyAndPolicy()
    {
        return view('pages.privacy-policy', ['pageTitle' => '', 'description' => '']);
    }
    public function contactUs(Request $request)
    {
        return view('pages.contact-us', ['pageTitle' => '', 'description' => '']);
    }
    public function feature()
    {
        return view('pages.feature', ['pageTitle' => '', 'description' => '']);
    }
    public function technology()
    {
        return view('pages.technology', ['pageTitle' => '', 'description' => '']);
    }
    public function paymentMethod()
    {
        return view('pages.payment-method', ['pageTitle' => '', 'description' => '']);
    }
    public function faq()
    {
        return view('pages.need-help', ['pageTitle' => '', 'description' => '']);
    }
    public function giveFeedBack()
    {
        return view('pages.give-feedback', ['pageTitle' => '', 'description' => '']);
    }
}
